 ; Ŀ
 ;   Surv - move stuff to a given layer without altering its appearance.   
 ;   In other words make colour and linetype intrinsic, then relayer.      
 ;   Copyright 2005 by Rocket Software Ltd.                                
 ;   Surveyors think that every atom needs its own layer.                  
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd colo / reps pa pa1 pa2 angg)
  (setq reps 32)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Surv.                                                                 
 ; 
 (DEFUN C:SURV (/ rad prom enampt enam dest8 ss num entt pa elay ecol asoc62
                                                          eltyp asoc6 ladat)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 135))
 ; Ŀ
 ;   Get a destination layer.                                              
 ; 
  (if (/= (type laya) 'STR)
      (setq laya "0"))
  (setq prom (strcat "Destination Layer <" laya "> or select entity: "))
  (if (setq enampt (entsel prom))
      (progn
           (setq enam (car enampt))
           (setq laya (cdr (assoc 8 (entget enam))))
           (if (= (type laya) 'STR) (princ laya))))
 ; Ŀ
 ;   Get stuff to modify.                                                  
 ; 
  (setq ss (ssget))
  (setq num 0)
 ; Ŀ
 ;   For each entity in the selection set:                                 
 ; 
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq pa (cdr (assoc 10 entt)))                  ; entity insertion
         (setq elay (cdr (setq asoc8 (assoc 8 entt))))    ; entity layer
         (setq ecol (cdr (setq asoc62 (assoc 62 entt))))  ; entity colour
         (setq eltyp (cdr (setq asoc6 (assoc 6 entt))))   ; entity linetype
 ; Ŀ
 ;   Get the data for the layer occupied by the entity.                    
 ; 
         (setq ladat (tblsearch "layer" elay))
 ; Ŀ
 ;   If the entity is coloured bylayer, explicitly colour it.              
 ; 
         (cond ((null ecol)
                (entmod (setq entt (append entt (list (assoc 62 ladat))))))
               ((= ecol 256)
                (entmod (setq entt (subst (assoc 62 ladat) asoc62 entt)))))
 ; Ŀ
 ;   If the entity was linetyped bylayer, explicitly linetype it.          
 ; 
         (cond ((null eltyp)
                (entmod (setq entt (append entt (list (assoc 6 ladat))))))
               ((= (strcase eltyp t) "byblock")
                (entmod (setq entt (subst (assoc 6 ladat) asoc6 entt)))))
 ; Ŀ
 ;   Move the entity to the destination layer.                             
 ; 
         (entmod (subst (cons 8 laya) asoc8 entt))
 ; Ŀ
 ;   Mark the entity, largely to show that something has happened.         
 ; 
         (ci pa rad 7)
         (mark pa (* rad 1.45) 7))
  (command "undo" "end")
 (princ))